/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.util;

import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.util.DateTimePatternData;
import com.ibm.hwmca.fw.util.DateTimeSeconds;
import com.ibm.hwmca.fw.util.HexString;
import com.ibm.hwmca.fw.util.Trace;
import java.text.DateFormat;
import java.text.DateFormatSymbols;
import java.text.SimpleDateFormat;
import java.util.Locale;

public class DateTimePattern {
    private static final String TRACE_MASKT = "XFRMDTPT";
    private static final String TRACE_MASKF = "XFRMDTPF";
    private static final String TRACE_MASKD = "XFRMDTPD";
    private static final String YEAR_PATTERN = "yyyy";
    private static final String MONTH_PATTERN = "MM";
    private static final String DAY_PATTERN = "dd";
    private static final String HOUR_24_PATTERN = "HH";
    private static final String SECONDS_PATTERN = "ss";
    private static final String MINUTES_PATTERN = "mm";
    private static final String MILLISECOND_PATTERN = ".SSS";
    private static final char YEAR_CHAR = 'y';
    public static final char MONTH_CHAR = 'M';
    public static final char DAY_CHAR = 'd';
    public static final char MINUTES_CHAR = 'm';
    public static final char SECONDS_CHAR = 's';
    private static final char FORM_12_HOUR_CHAR = 'h';
    private static final char FORM_24_HOUR_CHAR = 'H';
    public static final char MILLISECONDS_CHAR = 'S';
    private static final char AM_PM_CHAR = 'a';
    private static final char TIME_ZONE_CHAR = 'z';

    public static DateFormat getDatePattern(Locale locale) {
        DateFormat df;
        block7: {
            Trace.trace(TRACE_MASKF, "->  getDatePattern()");
            df = DateFormat.getDateInstance(3, locale);
            if (df instanceof SimpleDateFormat) {
                SimpleDateFormat dateFormatter = (SimpleDateFormat)df;
                String datePattern = dateFormatter.toPattern();
                Trace.trace(TRACE_MASKF, "orgDatePattern=[" + datePattern + "] Locale Country=" + locale.getDisplayCountry() + " lang=" + locale.getDisplayLanguage());
                try {
                    DateTimePatternData dtpd = DateTimePattern.getIndexData(datePattern.toCharArray(), 'y');
                    if (dtpd != null) {
                        if ((dtpd = DateTimePattern.getIndexData((datePattern = DateTimePattern.replaceWithNewString(datePattern, dtpd.getStartIndex(), dtpd.getLastIndex(), YEAR_PATTERN)).toCharArray(), 'M')) != null) {
                            datePattern = DateTimePattern.replaceWithNewString(datePattern, dtpd.getStartIndex(), dtpd.getLastIndex(), MONTH_PATTERN);
                        }
                        if ((dtpd = DateTimePattern.getIndexData(datePattern.toCharArray(), 'd')) != null) {
                            datePattern = DateTimePattern.replaceWithNewString(datePattern, dtpd.getStartIndex(), dtpd.getLastIndex(), DAY_PATTERN);
                        }
                        datePattern = datePattern.trim();
                        Trace.trace(TRACE_MASKF, "newDatePattern=[" + datePattern + "]");
                        dateFormatter.applyPattern(datePattern);
                        break block7;
                    }
                    Trace.trace(TRACE_MASKF, "year was not part of the date format");
                }
                catch (HException hexc) {
                    Trace.trace(TRACE_MASKF, "there was an error with the date pattern");
                    Trace.trace(TRACE_MASKF, hexc);
                }
            } else {
                Trace.trace(TRACE_MASKF, "DateFormat is not an instance of SimpleDateFormat");
                Trace.trace(TRACE_MASKF, "Locale Country=" + locale.getDisplayCountry() + " lang=" + locale.getDisplayLanguage());
            }
        }
        Trace.trace(TRACE_MASKF, "<-  getDatePattern()");
        return df;
    }

    public static DateFormat getTimePattern(Locale locale) {
        Trace.trace(TRACE_MASKT, "->  getTimePattern()");
        DateTimeSeconds dts = null;
        try {
            dts = DateTimePattern.getTimeWithSeconds(locale);
            DateFormatSymbols dfs = new DateFormatSymbols(Locale.US);
            String validCharacters = dfs.getLocalPatternChars();
            Trace.trace(TRACE_MASKF, "localPatternChars=" + validCharacters);
            if (dts.getSecondsExist()) {
                String newPattern = DateTimePattern.removeIt(dts.getTimePattern(), 'z', validCharacters);
                newPattern = newPattern.trim();
                Trace.trace(TRACE_MASKF, "newTimePattern=[" + newPattern + "]");
                dts.getSTimeFormatter().applyPattern(newPattern);
            } else {
                Trace.trace(TRACE_MASKF, "will return the org DateFormat pattern");
            }
        }
        catch (HException hexc) {
            Trace.trace(TRACE_MASKF, "Problem parsing time pattern.  Use default");
            Trace.trace(TRACE_MASKF, hexc);
        }
        Trace.trace(TRACE_MASKT, "<-  getTimePattern()");
        return dts.getTimeFormat();
    }

    public static DateFormat getTimeWithMillisecondsPattern(Locale locale) {
        Trace.trace(TRACE_MASKT, "->  getTimePatternWithMilliseconds()");
        DateTimeSeconds dts = null;
        DateFormatSymbols dfs = new DateFormatSymbols(Locale.US);
        String validCharacters = dfs.getLocalPatternChars();
        try {
            dts = DateTimePattern.getTimeWithSeconds(locale);
            if (dts.getSecondsExist()) {
                String timePattern = dts.getTimePattern();
                DateTimePatternData dtpdMillisec = DateTimePattern.getIndexData(timePattern.toCharArray(), 'S');
                timePattern = dtpdMillisec == null ? DateTimePattern.replaceWithNewString(timePattern, dts.getDateTimePatternData().getStartIndex(), dts.getDateTimePatternData().getLastIndex(), "ss.SSS") : DateTimePattern.replaceWithNewString(timePattern, dts.getDateTimePatternData().getStartIndex(), dts.getDateTimePatternData().getLastIndex(), SECONDS_PATTERN);
                Trace.trace(TRACE_MASKF, "timeWithMillisec=[" + timePattern + "]");
                DateTimePatternData dtpdMinute = DateTimePattern.getIndexData(timePattern.toCharArray(), 'm');
                if (dtpdMinute != null) {
                    timePattern = DateTimePattern.replaceWithNewString(timePattern, dtpdMinute.getStartIndex(), dtpdMinute.getLastIndex(), MINUTES_PATTERN);
                }
                timePattern = DateTimePattern.removeIt(timePattern, 'a', validCharacters);
                Trace.trace(TRACE_MASKF, "timePatternNoAmPm=[" + timePattern + "]");
                timePattern = DateTimePattern.removeIt(timePattern, 'z', validCharacters);
                Trace.trace(TRACE_MASKF, "timePatternNoTimeZone=[" + timePattern + "]");
                DateTimePatternData dtpd24Hour = DateTimePattern.getIndexData(timePattern.toCharArray(), 'H');
                DateTimePatternData dtpd12Hour = DateTimePattern.getIndexData(timePattern.toCharArray(), 'h');
                if (dtpd24Hour != null || dtpd12Hour != null) {
                    int startIndex = 0;
                    int lastIndex = 0;
                    if (dtpd24Hour != null) {
                        startIndex = dtpd24Hour.getStartIndex();
                        lastIndex = dtpd24Hour.getLastIndex();
                    } else {
                        startIndex = dtpd12Hour.getStartIndex();
                        lastIndex = dtpd12Hour.getLastIndex();
                    }
                    timePattern = DateTimePattern.replaceWithNewString(timePattern, startIndex, lastIndex, HOUR_24_PATTERN);
                    Trace.trace(TRACE_MASKF, "timePattern24H=[" + timePattern + "]");
                    dts.getSTimeFormatter().applyPattern(timePattern);
                    timePattern = timePattern.trim();
                    Trace.trace(TRACE_MASKF, "newTimePattern=[" + timePattern + "]");
                } else {
                    Trace.trace(TRACE_MASKF, "No hours specified in the pattern");
                }
            } else {
                Trace.trace(TRACE_MASKF, "will return org date format");
            }
        }
        catch (HException hexc) {
            Trace.trace(TRACE_MASKF, "there was an error with the time pattern. Use default");
            Trace.trace(TRACE_MASKF, hexc);
        }
        Trace.trace(TRACE_MASKT, "<-  getTimePatternWithMilliseconds()");
        return dts.getTimeFormat();
    }

    private static String insertText(String pattern, String insertTextStr, int insertAfterIndex) {
        int len = pattern.length();
        String newPattern = null;
        newPattern = insertAfterIndex + 1 == len ? pattern + insertTextStr : pattern.substring(0, insertAfterIndex + 1) + insertTextStr + pattern.substring(insertAfterIndex + 1);
        return newPattern;
    }

    public static DateTimePatternData getIndexData(char[] pattern, char chr) throws HException {
        DateTimePatternData dtpd = null;
        int len = pattern.length;
        int lastIndex = -1;
        int i = 0;
        while (i < len && dtpd == null) {
            if (pattern[i] == '\'') {
                lastIndex = DateTimePattern.findNextOne(pattern, '\'', i + 1, len);
                if (lastIndex == -1) {
                    throw new HException("pattern didn't have an ending single quote");
                }
                i = lastIndex + 1;
                continue;
            }
            if (pattern[i] == chr) {
                lastIndex = DateTimePattern.findLastInSequence(pattern, chr, i, len);
                dtpd = new DateTimePatternData();
                dtpd = new DateTimePatternData();
                dtpd.setStartIndex(i);
                dtpd.setLastIndex(lastIndex);
                continue;
            }
            ++i;
        }
        return dtpd;
    }

    private static String replaceWithNewString(String pattern, int startIndex, int lastIndex, String replacementString) {
        int len = pattern.length();
        String newPattern = null;
        newPattern = startIndex == 0 ? replacementString : new String(pattern.substring(0, startIndex) + replacementString);
        if (lastIndex + 1 < len) {
            newPattern = newPattern + new String(pattern.substring(lastIndex + 1));
        }
        return newPattern;
    }

    private static String removeCharacters(String pattern, int startIndex, int lastIndex) {
        Trace.trace(TRACE_MASKF, "removeChar from startIndex=" + startIndex + " to lastIndex=" + lastIndex);
        int len = pattern.length();
        pattern = startIndex == 0 ? pattern.substring(lastIndex + 1) : (lastIndex + 1 == len ? pattern.substring(0, startIndex) : pattern.substring(0, startIndex) + pattern.substring(lastIndex + 1));
        return pattern;
    }

    private static int findNextOne(char[] pattern, char chr, int startIndex, int len) {
        int nextOne = -1;
        int i = startIndex;
        while (i < len) {
            if (pattern[i] == chr) {
                nextOne = i;
                i = len;
            }
            ++i;
        }
        return nextOne;
    }

    private static int findPreviousOne(char[] pattern, char chr, int startIndex) {
        int previousOne = -1;
        int i = startIndex;
        while (i > -1) {
            if (pattern[i] == chr) {
                previousOne = i;
                i = -1;
            }
            Trace.trace(TRACE_MASKD, "previousIndex=" + previousOne + " for hexFormChr=" + HexString.toHex(chr));
            --i;
        }
        return previousOne;
    }

    private static int findLastInSequence(char[] pattern, char chr, int startIndex, int len) {
        int nextOne = startIndex;
        int i = startIndex;
        while (i < len) {
            if (pattern[i] == chr) {
                nextOne = i;
            } else {
                i = len;
            }
            ++i;
        }
        return nextOne;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static DateTimePatternData getIndexPreviousDelimeter(String pattern, String validCharacters, DateTimePatternData dtpd) throws HException {
        char[] patternAr = pattern.toCharArray();
        int startIndex = dtpd.getStartIndex();
        int lastIndex = dtpd.getLastIndex();
        DateTimePatternData delIndex = null;
        if (startIndex == 0) return delIndex;
        int index = startIndex - 1;
        char chr = patternAr[index];
        if (chr == '\'') {
            delIndex = new DateTimePatternData();
            int prevIndex = DateTimePattern.findPreviousOne(patternAr, '\'', index - 1);
            if (prevIndex < 0) throw new HException("No matching single quote");
            delIndex.setStartIndex(prevIndex);
            delIndex.setLastIndex(index);
            Trace.trace(TRACE_MASKD, "single quote startIndex=" + prevIndex + " lastIndex=" + index);
            return delIndex;
        } else {
            int validIndex;
            if (Character.isWhitespace(chr) || (validIndex = validCharacters.indexOf(chr)) != -1) return delIndex;
            delIndex = new DateTimePatternData();
            delIndex.setStartIndex(index);
            delIndex.setLastIndex(index);
        }
        return delIndex;
    }

    private static String removeIt(String pattern, char chr, String validCharacters) throws HException {
        DateTimePatternData dtpd = DateTimePattern.getIndexData(pattern.toCharArray(), chr);
        if (dtpd != null) {
            DateTimePatternData delimIndex = DateTimePattern.getIndexPreviousDelimeter(pattern, validCharacters, dtpd);
            if (delimIndex != null) {
                dtpd.setStartIndex(delimIndex.getStartIndex());
            }
            pattern = DateTimePattern.removeCharacters(pattern, dtpd.getStartIndex(), dtpd.getLastIndex());
        }
        return pattern;
    }

    private static DateTimeSeconds getTimeWithSeconds(Locale locale) throws HException {
        DateTimeSeconds dts = new DateTimeSeconds(locale, 2);
        if (!dts.getSecondsExist()) {
            dts = new DateTimeSeconds(locale, 1);
        }
        return dts;
    }
}

